const BASIC = 'Basic ' + btoa('adminvcp:vcpadmin123');

async function fetchUsers(q = '') {
  const res = await fetch('/api/admin/users' + (q ? `?q=${encodeURIComponent(q)}` : ''), { headers: { Authorization: BASIC }});
  if (!res.ok) { alert('Admin auth failed'); return []; }
  return res.json();
}

function row(u) {
  const tr = document.createElement('tr');
  tr.innerHTML = `<td>${u.id}</td><td>${u.email}</td><td>${u.username}</td><td>${new Date(u.created_at).toLocaleString()}</td>`;
  const td = document.createElement('td'); td.className = 'text-end';

  const btnReset = document.createElement('button'); btnReset.className = 'btn btn-sm btn-outline-primary me-2'; btnReset.textContent = 'Reset Password';
  btnReset.onclick = async () => {
    const pw = prompt('Enter new password for @' + u.username);
    if (!pw) return;
    await fetch(`/api/admin/users/${u.id}`, { method: 'PATCH', headers: { 'Content-Type': 'application/json', Authorization: BASIC }, body: JSON.stringify({ password: pw }) });
    alert('Password updated');
  };

  const btnRename = document.createElement('button'); btnRename.className = 'btn btn-sm btn-outline-secondary me-2'; btnRename.textContent = 'Rename';
  btnRename.onclick = async () => {
    const nu = prompt('New username', u.username); if (!nu) return;
    const resp = await fetch(`/api/admin/users/${u.id}`, { method: 'PATCH', headers: { 'Content-Type': 'application/json', Authorization: BASIC }, body: JSON.stringify({ username: nu }) });
    if (resp.ok) load();
  };

  const btnDelete = document.createElement('button'); btnDelete.className = 'btn btn-sm btn-danger'; btnDelete.textContent = 'Delete';
  btnDelete.onclick = async () => {
    if (!confirm('Delete user #' + u.id + ' ?')) return;
    await fetch(`/api/admin/users/${u.id}`, { method: 'DELETE', headers: { Authorization: BASIC } });
    load();
  };

  td.append(btnReset, btnRename, btnDelete); tr.appendChild(td);
  return tr;
}

async function load() {
  const q = document.getElementById('search').value.trim();
  const list = await fetchUsers(q);
  const tb = document.getElementById('tbody'); tb.innerHTML = '';
  list.forEach(u => tb.appendChild(row(u)));
}

document.getElementById('refresh').onclick = load;
document.getElementById('search').addEventListener('keydown', (e) => { if (e.key === 'Enter') load(); });

load();
