const API = '/api';
const alertBox = document.getElementById('authAlert');

function showError(msg) {
  alertBox.textContent = msg; alertBox.classList.remove('d-none');
}

function saveSession({ token, user }) {
  localStorage.setItem('token', token);
  localStorage.setItem('user', JSON.stringify(user));
}

function getFormData(form) { return Object.fromEntries(new FormData(form).entries()); }

// Redirect if already logged in
if (localStorage.getItem('token')) {
  window.location.href = '/dashboard.html';
}

// Login
const loginForm = document.getElementById('loginForm');
loginForm?.addEventListener('submit', async (e) => {
  e.preventDefault();
  alertBox.classList.add('d-none');
  const payload = getFormData(loginForm);
  try {
    const res = await fetch(`${API}/auth/login`, {
      method: 'POST', headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(payload)
    });
    const data = await res.json();
    if (!res.ok) throw new Error(data.message || 'Login failed');
    saveSession(data);
    window.location.href = '/dashboard.html';
  } catch (err) {
    showError(err.message);
  }
});

// Register
const registerForm = document.getElementById('registerForm');
registerForm?.addEventListener('submit', async (e) => {
  e.preventDefault();
  alertBox.classList.add('d-none');
  const payload = getFormData(registerForm);
  try {
    const res = await fetch(`${API}/auth/register`, {
      method: 'POST', headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(payload)
    });
    const data = await res.json();
    if (!res.ok) throw new Error(data.message || 'Registration failed');
    saveSession(data);
    window.location.href = '/dashboard.html';
  } catch (err) {
    showError(err.message);
  }
});
