self.addEventListener('install', (e) => self.skipWaiting());
self.addEventListener('activate', (e) => self.clients.claim());

self.addEventListener('push', (event) => {
  let payload = {};
  try { payload = event.data?.json() || {}; } catch {}
  const title = payload.title || 'Notification';
  const options = {
    body: payload.body || '',
    data: payload.data || {},
    badge: '/favicon.ico',
    icon: '/favicon.ico',
  };
  event.waitUntil(self.registration.showNotification(title, options));
});

self.addEventListener('notificationclick', (event) => {
  event.notification.close();
  const url = event.notification.data?.url || '/dashboard.html';
  event.waitUntil((async () => {
    const all = await clients.matchAll({ type: 'window' });
    for (const c of all) { if (c.url.includes(url)) return c.focus(); }
    return clients.openWindow(url);
  })());
});
