import { Router } from 'express';
import { pool } from '../db.js';
import bcrypt from 'bcrypt';
import { adminRequired } from '../middleware/admin.js';

const router = Router();

router.get('/users', adminRequired, async (req, res) => {
  const q = (req.query.q || '').trim();
  const where = q ? 'WHERE email LIKE ? OR username LIKE ?' : '';
  const params = q ? [`%${q}%`, `%${q}%`] : [];
  const [rows] = await pool.query(`SELECT id, email, username, created_at FROM users ${where} ORDER BY created_at DESC LIMIT 200`, params);
  res.json(rows);
});

router.patch('/users/:id', adminRequired, async (req, res) => {
  const id = Number(req.params.id);
  const { email, username, password } = req.body || {};
  const fields = []; const params = [];
  if (email) { fields.push('email = ?'); params.push(email); }
  if (username) { fields.push('username = ?'); params.push(username); }
  if (password) { const hash = await bcrypt.hash(password, 10); fields.push('password_hash = ?'); params.push(hash); }
  if (!fields.length) return res.status(400).json({ message: 'No fields' });
  params.push(id);
  await pool.query(`UPDATE users SET ${fields.join(', ')} WHERE id = ?`, params);
  res.json({ ok: true });
});

router.delete('/users/:id', adminRequired, async (req, res) => {
  const id = Number(req.params.id);
  await pool.query('DELETE FROM users WHERE id = ?', [id]);
  res.json({ ok: true });
});

export default router;
