import { Router } from 'express';
import { RtcTokenBuilder, RtcRole } from 'agora-access-token';
import { authRequired } from '../middleware/auth.js';

const router = Router();

router.get('/config', (req, res) => {
  // Expose only the public App ID to the client
  res.json({ appId: process.env.AGORA_APP_ID });
});

router.post('/token', authRequired, (req, res) => {
  const { channelName, uid } = req.body || {};
  if (!channelName || typeof channelName !== 'string')
    return res.status(400).json({ message: 'channelName required' });

  const realUid = Number(uid) || req.user.id; // fallback to authenticated user id

  const ttl = Number(process.env.AGORA_TOKEN_TTL_SECONDS || 3600);
  const currentTs = Math.floor(Date.now() / 1000);
  const expireTs = currentTs + ttl;

  try {
    const token = RtcTokenBuilder.buildTokenWithUid(
      process.env.AGORA_APP_ID,
      process.env.AGORA_APP_CERTIFICATE,
      channelName,
      realUid,
      RtcRole.PUBLISHER,
      expireTs
    );
    res.json({ token, uid: realUid, expiresAt: expireTs });
  } catch (e) {
    console.error(e);
    res.status(500).json({ message: 'Failed to create token' });
  }
});

export default router;
