import { Router } from 'express';
import { pool } from '../db.js';
import { authRequired } from '../middleware/auth.js';

const router = Router();

router.get('/', authRequired, async (req, res) => {
  const limit = Math.min(parseInt(req.query.limit || '50', 10), 100);
  try {
    const [rows] = await pool.query(
      `SELECT c.id, c.channel, c.status, c.started_at, c.ended_at, c.duration_seconds,
              c.caller_id, caller.username AS caller_username,
              c.callee_id, callee.username AS callee_username
       FROM calls c
       JOIN users caller ON caller.id = c.caller_id
       JOIN users callee ON callee.id = c.callee_id
       WHERE c.caller_id = ? OR c.callee_id = ?
       ORDER BY c.created_at DESC
       LIMIT ?`,
      [req.user.id, req.user.id, limit]
    );
    res.json(rows);
  } catch (e) {
    console.error(e);
    res.status(500).json({ message: 'Server error' });
  }
});

export default router;
