import { Router } from 'express';
import { pool } from '../db.js';
import { authRequired } from '../middleware/auth.js';

const router = Router();

router.get('/', authRequired, async (req, res) => {
  try {
    const [rows] = await pool.query(
      `SELECT u.id, u.username
       FROM contacts c
       JOIN users u ON u.id = c.contact_id
       WHERE c.user_id = ?
       ORDER BY u.username`,
      [req.user.id]
    );
    res.json(rows);
  } catch (e) {
    console.error(e);
    res.status(500).json({ message: 'Server error' });
  }
});

router.post('/:contactId', authRequired, async (req, res) => {
  const contactId = Number(req.params.contactId);
  if (!contactId || contactId === req.user.id) return res.status(400).json({ message: 'Invalid contact' });
  try {
    // Ensure user exists
    const [u] = await pool.query('SELECT id FROM users WHERE id = ? LIMIT 1', [contactId]);
    if (!u.length) return res.status(404).json({ message: 'User not found' });

    await pool.query(
      'INSERT IGNORE INTO contacts (user_id, contact_id) VALUES (?, ?)',
      [req.user.id, contactId]
    );
    res.status(201).json({ message: 'Added' });
  } catch (e) {
    console.error(e);
    res.status(500).json({ message: 'Server error' });
  }
});

export default router;
