import { Router } from 'express';
import { pool } from '../db.js';
import { authRequired } from '../middleware/auth.js';

const router = Router();

// Search users by username (partial match). Excludes self.
router.get('/', authRequired, async (req, res) => {
  const q = (req.query.q || '').trim();
  if (!q || q.length < 2) return res.json([]);
  try {
    const [rows] = await pool.query(
      'SELECT id, username FROM users WHERE username LIKE ? AND id <> ? ORDER BY username LIMIT 20',
      [`%${q}%`, req.user.id]
    );
    res.json(rows);
  } catch (e) {
    console.error(e);
    res.status(500).json({ message: 'Server error' });
  }
});

export default router;
